
/*---------------------------------------------------------------------------*\

    FILE....: VERBOSE.CPP
    TYPE....: C program
    AUTHOR..: John Kostogiannis
    DATE....: 7/11/97

    This function controls whether a print statements will appear or not.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>

#include "contypes.h"
#include "vpbapi.h"
#include "mess.h"
#include "verbose.h"

/*-------------------------------------------------------------------------*\

				FUNCTIONS

\*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*\

    FUNCTION.: verbose
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This functions manages the print statements for the console. 

\*-------------------------------------------------------------------------*/

void verbose(int state)
//	BOOL state	determines whether print statements are off or on
{
	if(state)
		mess_mprintf_on();		
	else
		mess_mprintf_off();
}
/*-------------------------------------------------------------------------*\

    FUNCTION.: verbose
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This functions manages the print statements for the console and to a file. 

\*-------------------------------------------------------------------------*/

void verbose_file(int state,char *fn)
//	BOOL state	determines whether print statements are off or on
{
	
	assert(fn!=NULL);
	if(state)
		mess_mprintf_on(fn);		
	else
		mess_mprintf_off();
}
/*-------------------------------------------------------------------------*\

    FUNCTION.: verbose
    AUTHOR...: John Kostogiannis
    DATE.....: 20/11/97

    This functions manages the print statements for the message window. 

\*-------------------------------------------------------------------------*/

void verbose_gui(int state,int h,int hInt)
//	BOOL state	determines whether print statements are off or on
{
	if(state)
		mess_mprintf_on(h,hInt);		
	else
		mess_mprintf_off();
}

